//
//  AccountHelper.h
//  aspdemo
//
//  Created by 杨航涛 on 2021/11/27.
//

#import <Foundation/Foundation.h>

NS_ASSUME_NONNULL_BEGIN

// UserInfo
@interface UserInfo : NSObject
@property NSString* region;
@property NSString* workspaceId;
@property NSString* userName;
@property NSString* userPwd;
@end

// CloudDesktop
@interface CloudDesktop : NSObject
@property NSString* chargeType; //PostPaid
@property NSString* connectionStatus; //Disconnected
@property NSString* desktopId; //ecd-canntjbsf4o7ll1ui
@property NSString* desktopName; //yuanxin-0930
@property NSString* desktopStatus; //Running
@property NSString* expiredTime; //2099-12-31T15:59Z
@property NSString* osType; //Windows
@property NSString* protocolType; //ASP, HDX
@end

// DesktopConnParam
@interface DesktopConnParam : NSObject
@property NSString* connTicket; //ticket
@property NSString* connIp; //ip
@property NSString* connPort; //port
@property NSString* connUdpPort; //udp port
@property NSString* connToken; // token for gateway
@property bool enableTls;
@property (nonatomic, copy) NSString *desktopId;
@end

#pragma mark --AccountHelper定义
/**
 * @brief AccountHelper
 */
@interface AccountHelper : NSObject

@end

NS_ASSUME_NONNULL_END
